using System.Collections.Generic;
using UnityEngine;
using UnityEngine.XR.ARFoundation;
using UnityEngine.XR.ARSubsystems;

[RequireComponent(typeof(ARRaycastManager))]
public class SpawnObjectWithIndicator : MonoBehaviour
{
    public GameObject indicatorPrefab; // titik indikator
    public GameObject objectPrefab;    // kubus final

    private ARRaycastManager raycastManager;
    private GameObject indicatorInstance;

    private static List<ARRaycastHit> hits = new List<ARRaycastHit>();

    void Start()
    {
        raycastManager = GetComponent<ARRaycastManager>();

        indicatorInstance = Instantiate(indicatorPrefab);
        indicatorInstance.SetActive(false);
    }

    void Update()
    {
        Vector2 screenCenter = new Vector2(Screen.width / 2, Screen.height / 2);

        // Raycast ke plane
        if (raycastManager.Raycast(screenCenter, hits, TrackableType.PlaneWithinPolygon))
        {
            Pose hitPose = hits[0].pose;

            // Tampilkan indicator titik, mengikuti plane
            indicatorInstance.SetActive(true);
            indicatorInstance.transform.position = hitPose.position;
            indicatorInstance.transform.rotation = hitPose.rotation;

            // Spawn kubus saat tap
            if (Input.touchCount > 0 && Input.GetTouch(0).phase == TouchPhase.Began)
            {
                Instantiate(objectPrefab, hitPose.position, hitPose.rotation);
            }
        }
        else
        {
            // sembunyikan indicator jika tidak ada plane
            indicatorInstance.SetActive(false);
        }
    }
}
